// fog.fs
//
// mga w oparciu o piksele

uniform float density;

void main(void)
{
    const vec4 fogColor = vec4(0.5, 0.8, 0.5, 1.0);

    // obliczenie wspczynnika mgy (wykadniczy drugiego stopnia)
    // w oparciu o wsprzdn Z fragmentu
    const float e = 2.71828;
    float fogFactor = (density * gl_FragCoord.z);
    fogFactor *= fogFactor;
    fogFactor = clamp(pow(e, -fogFactor), 0.0, 1.0);

    // zlewanie koloru mgy z kolorem wejciowym
    gl_FragColor = mix(fogColor, gl_Color, fogFactor);
}

